@extends('layouts.app')

@section('content')

<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View Roles</h6>
            </div>

            @can('edit-user')
            <div class="view-all-release-search">
                <a href="{{ route('roles.create') }}"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            @endcan
        </div>

        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>S#</th>
                        <th style="max-width:100px;">Role Name</th>
                        <th>Permissions</th>
                        <th style="width: 250px;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($roles as $role)
                    <tr>
                        <th scope="row">{{ $loop->iteration }}</th>
                        <td>{{ $role->name }}</td>
                        <td>
                            <ul>
                                @forelse ($role->permissions as $permission)
                                <li>{{ ucwords(str_replace("-"," ",$permission->name)) }}</li>
                                @empty
                                @endforelse
                            </ul>
                        </td>
                        <td>
                            <form action="{{ route('roles.destroy', $role->id) }}" method="post">
                                @csrf
                                @method('DELETE')

                                @if ($role->name!='Super Admin')
                                @can('edit-role')
                                <a href="{{ route('roles.edit', $role->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Edit</a>
                                @endcan

                                @can('delete-role')
                                @if ($role->name!=Auth::user()->hasRole($role->name))
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Do you want to delete this role?');"><i class="bi bi-trash"></i> Delete</button>
                                @endif
                                @endcan
                                @endif

                            </form>
                        </td>
                    </tr>
                    @empty
                    <td colspan="3">
                        <span class="text-danger">
                            <strong>No Role Found!</strong>
                        </span>
                    </td>
                    @endforelse

                </tbody>
            </table>

            {!! $roles->links('pagination::bootstrap-5') !!}





        </div>
    </div>
</section>

@endsection